
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data relevant to literature domain (lengths of different types of books)
novel_lengths = np.random.normal(300, 50, 1000)  # Mean = 300, SD = 50
short_story_lengths = np.random.normal(50, 20, 1000)  # Mean = 50, SD = 20
poetry_lengths = np.random.normal(120, 30, 1000)  # Mean = 120, SD = 30
essay_lengths = np.random.normal(180, 40, 1000)  # Mean = 180, SD = 40

# Define the titles for each subplot
titles = [
    "Novel Lengths",
    "Short Story Lengths",
    "Poetry Collection Lengths",
    "Essay Collection Lengths",
    "Novel Lengths (Variation 2)",
    "Short Story Lengths (Variation 2)",
    "Poetry Collection Lengths (Variation 2)",
    "Essay Collection Lengths (Variation 2)",
]

xlabel = "Length (pages)"
ylabel = "Density"
bins = 30
xvline = 200  # Using 200 pages as a common benchmark length

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 10))  # Adjusted to wider dimensions
# Define the colors for each subplot
colors = [
    "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728",
    "#9467bd", "#8c564b", "#e377c2", "#7f7f7f",
]
# Create subplots
for i in range(8):
    plt.subplot(4, 2, i + 1)
    if i % 2 == 0:
        data = novel_lengths if i == 0 else (poetry_lengths if i == 2 else short_story_lengths if i == 4 else essay_lengths)
    else:
        data = novel_lengths if i == 1 else (poetry_lengths if i == 3 else short_story_lengths if i == 5 else essay_lengths)
    plt.hist(data, bins=bins, density=True, alpha=0.6, color=colors[i], range=(0, 500))
    plt.title(titles[i])
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.axvline(x=xvline, color='k', linestyle='--', linewidth=1)  # Dashed line for benchmark length

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout(pad=0.4, w_pad=0.5, h_pad=1.0)  # Adjusted padding for tighter layout
plt.savefig("hist_55.pdf", bbox_inches="tight")
