# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random data for movie ratings
data1 = np.random.normal(7, 1.2, 1000)  # Genre 1: Action
data2 = np.random.normal(6, 1.5, 1000)  # Genre 2: Drama
data3 = np.random.normal(5, 1.0, 1000)  # Genre 3: Comedy
data4 = np.random.normal(8, 0.8, 1000)  # Genre 4: Sci-Fi

# Define the titles for each subplot
titles = [
    "Action",
    "Action (Annotated)",
    "Drama",
    "Drama (Annotated)",
    "Comedy",
    "Comedy (Annotated)",
    "Sci-Fi",
    "Sci-Fi (Annotated)",
]

# Define text labels
xlabel = "Rating"
ylabel = "Density"
bins = 20
xvline = 5
suptitle = "Movie Ratings Across Different Genres"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 16))  # Adjusted to a larger size for clarity
colors = [
    "#8c564b",
    "#8c564b",
    "#1f77b4",
    "#1f77b4",
    "#2ca02c",
    "#2ca02c",
    "#d62728",
    "#d62728",
]
# Create subplots
for i in range(8):
    plt.subplot(4, 2, i + 1)
    if i % 2 == 0:
        data = data1 if i < 4 else data3
    else:
        data = data2 if i < 4 else data4
    plt.hist(data, bins=bins, density=True, alpha=0.6, color=colors[i], range=(0, 10))
    plt.title(titles[i], fontsize=12)
    plt.xlabel(xlabel, fontsize=10)
    plt.ylabel(ylabel, fontsize=10)
    plt.axvline(
        x=xvline, color="k", linestyle="--", linewidth=1
    )  # Changed to dashed line
    plt.grid(True, linestyle="--", alpha=0.4)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.suptitle(suptitle, fontsize=16)
plt.tight_layout(pad=0.4, w_pad=0.5, h_pad=1.5)  # Adjusted padding for tighter layout
plt.subplots_adjust(top=0.95)  # Adjust to make room for supertitle
plt.savefig("hist_56.pdf", bbox_inches="tight")
