
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate new sample data for art sales
contemporary_art_sales = np.random.normal(5000, 1500, 1000)  # Normal distribution around 5000
modern_art_sales = np.random.beta(2, 5, 1000) * 8000  # Positively skewed distribution

# Define bins with suitable width
bin_width = 500
bins = np.arange(0, 10001, bin_width)

# Text labels and parameters
labels = ["Contemporary Art", "Modern Art"]
xlabel = "Sale Price ($)"
ylabel = "Number of Sales"
title = "Art Sale Price Distribution Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjust size for better readability

# Plot histograms using plt.hist() with adjustments for clarity
ax.hist(
    contemporary_art_sales,
    bins=bins,
    alpha=0.7,
    label=labels[0],
    color="#3498db",
    edgecolor="black",
)
ax.hist(
    modern_art_sales,
    bins=bins,
    alpha=0.7,
    label=labels[1],
    color="#e74c3c",
    edgecolor="black",
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid for better readability
ax.grid(color="#cccccc", linestyle="--", linewidth=0.7, zorder=0)

# Add legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping
plt.tight_layout()

# Save the plot
plt.savefig("hist_62.pdf", bbox_inches="tight")
