

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for PM2.5 concentrations in two urban areas
urban_area_1 = np.random.normal(loc=30, scale=5, size=1000)
urban_area_2 = np.random.normal(loc=70, scale=10, size=1000)

# Labels and Plot Types
hist_label = ["Urban Area 1", "Urban Area 2"]

# Axes Limits and Labels
xlabel_value = "PM2.5 Concentration (μg/m³)"
ylabel_value = "Frequency"
title = "PM2.5 Concentration Distribution in Two Urban Areas"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 5))

# Plot histograms with stacked bars, modified colors, and alpha for transparency
plt.hist(
    [urban_area_1, urban_area_2],
    bins=50,
    stacked=True,
    label=hist_label,
    color=["#77DD77", "#FFB347"],  # Green and Orange
    alpha=0.7,
)

# Add labels, title, and modify the style of the labels
plt.xlabel(xlabel_value, color="#333333")
plt.ylabel(ylabel_value, color="#333333")
plt.title(title)

# Modify the legend style and position to lower center
plt.legend(frameon=True, loc="lower center", ncol=2, bbox_to_anchor=(0.5, -0.25))

# Adjust x-axis range and add some space at the beginning of the x-axis
plt.xlim(left=min(urban_area_1.min(), urban_area_2.min()) - 5, right=max(urban_area_1.max(), urban_area_2.max()) + 5)

# Add grid with lighter color and set behind the histograms
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_68.pdf", bbox_inches="tight")

