
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New population data
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa"
]

# Generating plausible population data for different regions (in millions)
population_data = np.array(
    [
        np.random.randint(300, 500, 100),  # North America
        np.random.randint(400, 700, 100),  # Europe
        np.random.randint(800, 1500, 100),  # Asia
        np.random.randint(200, 400, 100),  # South America
        np.random.randint(100, 250, 100),  # Africa
    ]
)

xlabel = "Population (in millions)"
ylabel = "Frequency"
title = "Histogram of Population Distribution Across Different Continents"
# Histogram bins
bins = np.linspace(0, 1600, 30)  # Adjusted bin range to accommodate new data

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 8))
# Define distinct colors for the population theme
business_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
for i, region in enumerate(regions):
    plt.hist(
        population_data[i],
        bins=bins,
        alpha=0.6,
        color=business_colors[i % len(business_colors)],
        label=region,
        edgecolor="black",  # Adding edge color to improve readability
    )

plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)
plt.legend(loc="upper right", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_72.pdf", bbox_inches="tight")
