

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Law domain data
subjects = [
    "Constitutional Law",
    "Criminal Law",
    "Contract Law",
    "Torts",
    "Property Law",
]

# Generate random test scores for each subject over multiple classes
test_scores = np.array(
    [
        np.random.randint(50, 100, 100),  # Constitutional Law
        np.random.randint(55, 100, 100),  # Criminal Law
        np.random.randint(60, 100, 100),  # Contract Law
        np.random.randint(65, 100, 100),  # Torts
        np.random.randint(70, 100, 100),  # Property Law
    ]
)

xlabel = "Test Scores"
ylabel = "Frequency"
title = "Histogram of Test Scores Across Different Law Subjects"
bins = np.linspace(50, 100, 25)  # Adjusted bin range to accommodate score range

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 8))
# Define a pleasing color palette for the law domain
education_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
for i, subject in enumerate(subjects):
    plt.hist(
        test_scores[i],
        bins=bins,
        alpha=0.6,
        color=education_colors[i % len(education_colors)],
        label=subject,
        edgecolor='black'
    )

plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)
plt.legend(loc="upper right", fontsize=12)
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("hist_73.pdf", bbox_inches="tight")

