

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Data for the Science domain
science_categories = [
    "Number of Research Papers Published",
    "Number of Active Researchers",
    "Number of Patents Filed",
    "Number of Research Grants Awarded",
    "Number of Science Conferences Held",
]

# Generate synthetic data for each category
science_data_distributions = {
    "Number of Research Papers Published": np.random.normal(loc=500, scale=100, size=100),
    "Number of Active Researchers": np.random.normal(loc=300, scale=60, size=100),
    "Number of Patents Filed": np.random.normal(loc=100, scale=20, size=100),
    "Number of Research Grants Awarded": np.random.normal(loc=150, scale=30, size=100),
    "Number of Science Conferences Held": np.random.normal(loc=25, scale=5, size=100),
}

xlabel = "Number of Events"
ylabel = "Frequency"
title = "Histogram of Scientific Statistics Across Various Categories"
bins = np.linspace(0, 600, 30)  # Adjusted bin range to accommodate new data

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 8))
# Define new distinct cooler colors for the science domain
cooler_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

for i, category in enumerate(science_categories):
    plt.hist(
        science_data_distributions[category],
        bins=bins,
        alpha=0.6,
        color=cooler_colors[i % len(cooler_colors)],
        label=category,
    )

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_74.pdf", bbox_inches="tight")

