

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data simulating the number of days spent by tourists
domestic_tourists = np.random.normal(5, 2, 10000)
international_tourists = np.random.normal(10, 3, 10000)  # Larger variation in stay duration
domestic_tourists_variation = np.random.normal(6, 2.5, 10000)
international_tourists_variation = np.random.normal(8, 2.8, 10000)

# Chart text elements
suptitle = "Tourism Stay Duration Distribution"
binslist = [120, 120]
titles = ["Domestic Tourists", "International Tourists"]
labels = ["Primary Distribution", "Secondary Distribution"]
xlabel = "Stay Duration (in days)"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(12, 8), gridspec_kw={"hspace": 0.5})

# Overall title (suptitle)
fig.suptitle(suptitle, fontsize=16)

# Colors and styles
colors = ["#8B4513", "#BC8F8F"]
variance_colors = ["#2E8B57", "#8FBC8F"]

# First histogram (Domestic Tourists)
axs[0].hist(domestic_tourists, bins=binslist[0], range=(0, 20), alpha=0.6, label=labels[0], color=colors[0])
axs[0].hist(domestic_tourists_variation, bins=binslist[0], range=(0, 20), alpha=0.6, label=labels[1], color=colors[1])
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].grid(True, which='both', linestyle='--', linewidth=0.5)
axs[0].legend()

# Second histogram (International Tourists)
axs[1].hist(international_tourists, bins=binslist[1], range=(0, 20), alpha=0.6, label=labels[0], color=variance_colors[0])
axs[1].hist(international_tourists_variation, bins=binslist[1], range=(0, 20), alpha=0.6, label=labels[1], color=variance_colors[1])
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].grid(True, which='both', linestyle='--', linewidth=0.5)
axs[1].legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(rect=[0, 0.03, 1, 0.95])  # Adjust the layout to accommodate the overall title

plt.savefig("hist_76.pdf", bbox_inches="tight")
