# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for weekly hours spent on religious activities
religion1 = np.random.normal(5, 2, 10000)  # Religion A - more consistent participation
religion2 = np.random.normal(10, 4, 10000)  # Religion B - more varied participation
religion3 = np.random.normal(
    6, 2.5, 10000
)  # Another data for Religion A with slight variation
religion4 = np.random.normal(
    12, 5, 10000
)  # Another data for Religion B with higher variance

# Chart labels and titles
suptitle = "Weekly Religious Activity Participation Distribution"
binslist = [50, 50]
titles = ["Religion A - Weekly Participation", "Religion B - Weekly Participation"]
labels = ["Regular Participation", "Occasional Participation"]
ranges = (0, 20)
xlabel = "Weekly Hours Spent on Religious Activities"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.5})

# Overall title (suptitle)
fig.suptitle(suptitle)

# First histogram (Religion A)
color1a = "#33a02c"
color1b = "#1f78b4"
n, bins, patches = axs[0].hist(
    religion1, bins=binslist[0], range=ranges, alpha=0.7, label=labels[0], color=color1a
)
axs[0].hist(religion3, bins=bins, alpha=0.7, label=labels[1], color=color1b)
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].grid(True)  # Adding grid
axs[0].legend()  # Adding legend

# Second histogram (Religion B)
color2a = "#fb9a99"
color2b = "#e31a1c"
axs[1].hist(
    religion2,
    bins=binslist[1],
    range=ranges,
    alpha=0.7,
    label=labels[0],
    color=color2a,
)
axs[1].hist(religion4, bins=bins, alpha=0.7, label=labels[1], color=color2b)
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].grid(True)  # Adding grid
axs[1].legend()  # Adding legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(
    rect=[0, 0.03, 1, 0.95]
)  # Adjust the layout to accommodate the overall title

plt.savefig("hist_77.pdf", bbox_inches="tight")
