

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated Economic Data
# GDP Growth Rates (%)
data1_gdp_growth = np.concatenate(
    [np.random.normal(3, 0.8, 700), np.random.normal(1, 0.5, 300)]
)
data2_gdp_growth = np.concatenate(
    [np.random.normal(5, 1.0, 500), np.random.normal(2, 0.7, 500)]
)

# Inflation Rates (%)
data1_inflation = np.concatenate(
    [np.random.normal(2, 0.5, 600), np.random.normal(4, 0.8, 400)]
)
data2_inflation = np.concatenate(
    [np.random.normal(1.5, 0.4, 700), np.random.normal(3, 0.6, 300)]
)

# Unemployment Rates (%)
data1_unemployment = np.concatenate(
    [np.random.normal(6, 1, 500), np.random.normal(10, 1.5, 500)]
)
data2_unemployment = np.concatenate(
    [np.random.normal(5, 0.8, 700), np.random.normal(9, 1, 300)]
)

# Interest Rates (%)
data1_interest = np.concatenate(
    [np.random.normal(3, 0.6, 400), np.random.normal(2, 0.5, 600)]
)
data2_interest = np.concatenate(
    [np.random.normal(4, 0.7, 500), np.random.normal(3, 0.4, 500)]
)

binslist = [30, 30]
labels = ["Developed Economies", "Developing Economies"]
xlabel = "Rates (%)"
ylabel = "Density"
titles = [
    "(a) GDP Growth Rates",
    "(b) Inflation Rates",
    "(c) Unemployment Rates",
    "(d) Interest Rates",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Plot histograms for each subplot
datasets = [
    (data1_gdp_growth, data2_gdp_growth),
    (data1_inflation, data2_inflation),
    (data1_unemployment, data2_unemployment),
    (data1_interest, data2_interest),
]
colors = [("limegreen", "dodgerblue"), ("forestgreen", "mediumblue"),
          ("seagreen", "royalblue"), ("mediumseagreen", "steelblue")]

for (data1, data2), ax, (color1, color2) in zip(datasets, axs.flatten(), colors):
    ax.hist(
        data1,
        bins=binslist[0],
        density=True,
        alpha=0.6,
        color=color1,
        label=labels[0],
        edgecolor="black",
        linewidth=0.5,
    )
    ax.hist(
        data2,
        bins=binslist[1],
        density=True,
        alpha=0.6,
        color=color2,
        label=labels[1],
        edgecolor="black",
        linewidth=0.5,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True)
    ax.legend()

# Set titles for each subplot
axs[0, 0].set_title(titles[0])
axs[0, 1].set_title(titles[1])
axs[1, 0].set_title(titles[2])
axs[1, 1].set_title(titles[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("hist_78.pdf", bbox_inches="tight")

