

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random data for crop yields in two regions over Spring and Autumn
# Yield is normally distributed with different means and standard deviations
data_spring_region1 = np.random.normal(50, 10, 1000)  # Region 1, Spring
data_autumn_region1 = np.random.normal(60, 10, 1000)  # Region 1, Autumn

data_spring_region2 = np.random.normal(45, 8, 1000)  # Region 2, Spring
data_autumn_region2 = np.random.normal(55, 9, 1000)  # Region 2, Autumn

binslist = [30, 30]
labels = ["Region 1", "Region 2"]
xlabel = "Yield (Tons per hectare)"
ylabel = "Density"
titles = [
    "(a) Region 1 Spring vs Autumn",
    "(b) Region 2 Spring vs Autumn",
]
suptitle="Crop Yield Distributions in Two Regions Across Seasons"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(1, 2, figsize=(12, 6))

# Plot histograms for each subplot
datasets = [
    (data_spring_region1, data_autumn_region1),
    (data_spring_region2, data_autumn_region2),
]
colors = [("skyblue", "salmon"), ("cornflowerblue", "lightcoral")]

for (data_spring, data_autumn), ax, (color_spring, color_autumn) in zip(datasets, axs.flatten(), colors):
    ax.hist(
        data_spring,
        bins=binslist[0],
        density=True,
        alpha=0.6,
        color=color_spring,
        label=f"Spring - {labels[0]}",
        edgecolor="black",
        linewidth=0.5,
    )
    ax.hist(
        data_autumn,
        bins=binslist[1],
        density=True,
        alpha=0.6,
        color=color_autumn,
        label=f"Autumn - {labels[0]}",
        edgecolor="black",
        linewidth=0.5,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, linestyle='--', linewidth=0.7, alpha=0.7)
    ax.legend()

# Set titles for each subplot
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])

# Add a supertitle for the whole figure
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("hist_79.pdf", bbox_inches="tight")

