

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
employment_rate = [70, 71, 72, 73, 74, 75, 76, 77] # in percentages
crime_rate = [30, 29, 28, 27, 26, 25, 24, 23] # in incidents per 1000 people
internet_usage = [50, 55, 60, 65, 70, 75, 80, 85] # in percentages

# Positions for the bars on the x-axis
ind = np.arange(len(years))

# Labels and Legend
xlabel = "Year"
ylabel = "Percentage / Incidents per 1000"
employment_label = "Employment Rate"
crime_rate_label = "Crime Rate"
internet_usage_label = "Internet Usage"

# Limits
xlim = (years[0], years[-1])
ylim = (20, 90)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjust the size to match the original image's dimensions
ax.plot(years, employment_rate, label=employment_label, color="#2a9d8f", linestyle='-', marker='o')
ax.plot(years, crime_rate, label=crime_rate_label, color="#e76f51", linestyle='--', marker='s')
ax.plot(years, internet_usage, label=internet_usage_label, color="#264653", linestyle='-.', marker='^')

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 20 to 90
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of years without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Legend
ax.legend(
    loc="upper center", fontsize=14, frameon=False, ncol=3, bbox_to_anchor=(0.5, 1.15)
)

# Grid
ax.grid(True, ls="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_100.pdf", bbox_inches="tight")
