

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
regions = ["City A", "City B", "City C", "City D"]
temperature = [22, 25, 27, 23]
humidity = [65, 70, 75, 60]
precipitation = [5, 10, 15, 20]

# Extracted variables
line_label_temperature = "Temperature"
line_label_humidity = "Humidity"
line_label_precipitation = "Precipitation"
xlim_values = (0.25, 1)
ylim_values = (0, 80)
xlabel_value = "City"
ylabel_value = "Weather Metrics"
xticks_values = np.arange(len(regions))

# Label texts
chart_title = "Weather Metrics by City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14

# Plotting the lines with specific styles
plt.figure(figsize=(10, 6))
plt.plot(
    xticks_values,
    temperature,
    marker="o",
    markersize=8,
    linewidth=2,
    linestyle="-",
    color="#1f77b4",  # blue
    label=line_label_temperature
)
plt.plot(
    xticks_values,
    humidity,
    marker="s",
    markersize=8,
    linewidth=2,
    linestyle="--",
    color="#ff7f0e",  # orange
    label=line_label_humidity
)
plt.plot(
    xticks_values,
    precipitation,
    marker="+",
    markersize=12,
    linewidth=2,
    linestyle=":",
    color="#2ca02c",  # green
    label=line_label_precipitation
)

# Setting the x-axis and y-axis limits
plt.ylim(ylim_values)
plt.yticks(fontsize=ytickslabel_fontsize)
plt.xlim((0, len(regions)-1))
plt.xticks(xticks_values, regions, fontsize=xtickslabel_fontsize)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)
plt.title(chart_title, fontsize=20)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper center",
    ncol=3,
    frameon=False,
    bbox_to_anchor=(0.5, 1.15),
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_105.pdf", bbox_inches="tight")

