

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
years = [2010, 2012, 2014, 2016, 2018, 2020]
growth_rate_denom1 = [2.5, 2.9, 3.2, 3.7, 4.1, 4.5]
growth_rate_denom2 = [1.8, 2.1, 2.3, 2.6, 2.8, 3.0]
growth_rate_denom3 = [3.0, 3.5, 4.0, 4.3, 4.6, 5.0]

# Extracted variables
line_label_denom1 = "Denomination 1"
line_label_denom2 = "Denomination 2"
line_label_denom3 = "Denomination 3"
xlim_values = (2010, 2020)
ylim_values = (1.5, 5.5)
xlabel_value = "Year"
ylabel_value = "Congregation Growth Rate (%)"
title_value = "Growth Rate of Religious Congregations Over Years"
xticks_values = years
yticks_values = np.arange(1.5, 5.6, 0.5)  # Optional y-ticks values

xtickslabel_fontsize = 14
ytickslabel_fontsize = 14

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with increased marker size and line width
plt.figure(figsize=(8, 6))

plt.plot(
    years,
    growth_rate_denom1,
    marker="o",
    markersize=10,
    linewidth=2,
    linestyle="--",
    color="#1f77b4",  # Blue
    label=line_label_denom1,
    clip_on=False,
    zorder=10,
)
plt.plot(
    years,
    growth_rate_denom2,
    marker="^",
    markerfacecolor="white",
    markersize=10,
    linewidth=2,
    linestyle="-.",
    markeredgecolor="#ff7f0e",  # Orange
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    label=line_label_denom2,
)
plt.plot(
    years,
    growth_rate_denom3,
    marker="s",
    markerfacecolor="white",
    markersize=10,
    linewidth=2,
    linestyle=":",
    markeredgecolor="#2ca02c",  # Green
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    label=line_label_denom3,
)

# Setting the x-axis and y-axis limits
plt.ylim(*ylim_values)
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xlim(*xlim_values)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)
plt.title(title_value, fontsize=20)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper center",
    ncol=3,
    frameon=False,
    bbox_to_anchor=(0.5, 1.15),
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_106.pdf", bbox_inches="tight")

