

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Variable extraction
line_label_base = "Historical Data"
line_label_ours = "Projection"
xlim_values = (0, 20)
ylim_values_gdp = (0, 10)
ylim_values_inflation = (0, 15)
ylim_values_unemployment = (0, 10)
ylim_values_interest = (0, 10)
xlabel_value = "Years"
ylabel_value_gdp = "GDP Growth Rate (%)"
ylabel_value_inflation = "Inflation Rate (%)"
ylabel_value_unemployment = "Unemployment Rate (%)"
ylabel_value_interest = "Interest Rate (%)"
yticks_values_gdp = [0, 2, 4, 6, 8, 10]
yticks_values_inflation = [0, 3, 6, 9, 12, 15]
yticks_values_unemployment = [0, 2, 4, 6, 8, 10]
yticks_values_interest = [0, 2, 4, 6, 8, 10]

# Generated economics-related data
years = np.linspace(0, 20, 21)

# GDP Growth Data
base_data_gdp = np.random.normal(3, 1, 21) + np.linspace(0, 2, 21)
ours_data_gdp = np.random.normal(4, 1, 21) + np.linspace(0, 2.5, 21)

# Inflation Rate Data
base_data_inflation = np.random.normal(5, 2, 21) + np.linspace(0, 5, 21)
ours_data_inflation = np.random.normal(6, 2, 21) + np.linspace(0, 6, 21)

# Unemployment Rate Data
base_data_unemployment = np.random.normal(4, 1, 21) + np.linspace(0, 1, 21)
ours_data_unemployment = np.random.normal(5, 1, 21) + np.linspace(0, 1.5, 21)

# Interest Rate Data
base_data_interest = np.random.normal(3, 1, 21) + np.sin(0.2 * years) * 2
ours_data_interest = np.random.normal(4, 1, 21) + np.sin(0.2 * years) * 2

legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_frameon = False
legend_ncol = 2
grid_value = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(10, 14))

# Adjust color scheme
colors = {"Historical Data": "#1f77b4", "Projection": "#ff7f0e"}

# Plotting GDP Growth
axs[0].plot(years, base_data_gdp, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[0].plot(years, ours_data_gdp, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_gdp)
axs[0].set_xlim(*xlim_values)
axs[0].set_yticks(yticks_values_gdp)
axs[0].tick_params(axis="both", which="both", color="gray")

# Plotting Inflation Rate
axs[1].plot(years, base_data_inflation, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[1].plot(years, ours_data_inflation, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_inflation)
axs[1].set_xlim(*xlim_values)
axs[1].set_yticks(yticks_values_inflation)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting Unemployment Rate
axs[2].plot(years, base_data_unemployment, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[2].plot(years, ours_data_unemployment, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_unemployment)
axs[2].set_xlim(*xlim_values)
axs[2].set_yticks(yticks_values_unemployment)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting Interest Rate
axs[3].plot(years, base_data_interest, label=line_label_base, color=colors[line_label_base], linestyle='-', marker='o')
axs[3].plot(years, ours_data_interest, label=line_label_ours, color=colors[line_label_ours], linestyle='--', marker='s')
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_interest)
axs[3].set_xlim(*xlim_values)
axs[3].set_yticks(yticks_values_interest)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, ncol=legend_ncol)
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("line_109.pdf", bbox_inches="tight")
