# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for average daily temperatures
days = np.arange(1, 21)
city_A = np.linspace(10, 25, 20) + np.random.normal(0, 2, 20)
city_B = np.linspace(15, 30, 20) + np.random.normal(0, 1.5, 20)
city_C = np.linspace(20, 35, 20) + np.random.normal(0, 1, 20)
city_D = np.linspace(5, 20, 20) + np.random.normal(0, 0.5, 20)

# Axes Limits and Labels
xlabel_value = "Day"
xlim_values = [0.5, 20.5]
xticks_values = np.arange(1, 21, 1)

ylabel_value = "Temperature (°C)"
ylim_values = [-10, 40]
yticks_values = np.arange(-10, 41, 10)

# Labels
label_CityA = "City A"
label_CityB = "City B"
label_CityC = "City C"
label_CityD = "City D"

title = "Average Daily Temperatures Over 20 Days"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    days,
    city_A,
    marker="o",
    markersize=6,
    color="#1f77b4",
    linestyle="-",
    linewidth=2,
    label=label_CityA,
)
plt.plot(
    days,
    city_B,
    marker="s",
    markersize=6,
    color="#ff7f0e",
    linestyle="--",
    linewidth=2,
    label=label_CityB,
)
plt.plot(
    days,
    city_C,
    marker="^",
    markersize=6,
    color="#2ca02c",
    linestyle=":",
    linewidth=2,
    label=label_CityC,
)
plt.plot(
    days,
    city_D,
    marker="D",
    markersize=6,
    color="#d62728",
    linestyle="-.",
    linewidth=2,
    label=label_CityD,
)

# Set y-axis ticks and limits
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Setting x-axis ticks and limits
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=11, loc="upper left")

# Adding gridlines
plt.grid(True, linestyle="-", linewidth=0.5, axis="y", alpha=1)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_113.pdf", bbox_inches="tight")
