
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# New sample data for monthly average temperature trends
months = np.arange(1, 13)
city_A = np.linspace(10, 25, 12) + np.random.normal(0, 1, 12)
city_B = np.linspace(15, 30, 12) + np.random.normal(0, 1, 12)
city_C = np.linspace(5, 20, 12) + np.random.normal(0, 1, 12)
city_D = np.linspace(0, 15, 12) + np.random.normal(0, 1, 12)

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0.5, 12.5]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Average Temperature (°C)"
ylim_values = [-5, 35]
yticks_values = np.arange(-5, 36, 5)

# Labels
label_city_A = "City A"
label_city_B = "City B"
label_city_C = "City C"
label_city_D = "City D"
title = "Monthly Average Temperature for Different Cities"
suptitle = "Temperature Trends Over the Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))

# Colors
color_city_A = "#1f77b4"  # Blue
color_city_B = "#ff7f0e"  # Orange
color_city_C = "#2ca02c"  # Green
color_city_D = "#d62728"  # Red

plt.plot(
    months,
    city_A,
    marker="o",
    markersize=8,
    color=color_city_A,
    mfc="w",
    mew=2,
    linestyle="-",
    label=label_city_A,
    linewidth=2,
)
plt.plot(
    months,
    city_B,
    marker="s",
    markersize=8,
    color=color_city_B,
    mfc="w",
    mew=2,
    linestyle="--",
    label=label_city_B,
    linewidth=2,
)
plt.plot(
    months,
    city_C,
    marker="^",
    markersize=8,
    color=color_city_C,
    mfc="w",
    mew=2,
    linestyle=":",
    label=label_city_C,
    linewidth=2,
)
plt.plot(
    months,
    city_D,
    marker="d",
    markersize=8,
    color=color_city_D,
    mfc="w",
    mew=2,
    linestyle="-.",
    label=label_city_D,
    linewidth=2,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Setting x-axis ticks
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)
plt.suptitle(suptitle, fontsize=20)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=12, loc="upper right")

# Adding gridlines
plt.grid(True, linestyle="-", linewidth=0.5, axis="y", alpha=0.7)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_115.pdf", bbox_inches="tight")
