
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data: Literary Awards and Book Sales Over Time
years = [2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022]
fiction_share = [35, 37, 39, 40, 38, 36, 35, 34]
non_fiction_share = [25, 26, 27, 28, 30, 32, 33, 34]
scifi_share = [15, 16, 17, 18, 17, 17, 18, 18]

# Extracted variables
fiction_label = "Fiction"
non_fiction_label = "Non-Fiction"
scifi_label = "Science Fiction"

ylim_values = [0, 50]
yticks_values = [0, 10, 20, 30, 40, 50]
yticks_labels = ["$0$", "$10$", "$20$", "$30$", "$40$", "$50$"]
xlabel_value = "Year"
ylabel_value = "Market Share (%)"
xlim_values = [2015, 2022]
xticks_fontsize = "12"
yticks_fontsize = "12"
xlabel_fontsize = "14"
ylabel_fontsize = "14"
title_value = "Literary Genres Market Share Over Time"
supertitle_value = "Literary Trends (2015-2022)"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

legend_location = "upper left"
legend_ncol = 3
legend_bbox_to_anchor = (0, 0.95)
legend_frameon = False

# Plot the data
ax.plot(
    years,
    fiction_share,
    "o-",
    label=fiction_label,
    clip_on=False,
    zorder=10,
    color="#1f77b4",  # blue
    linewidth=2.0,
    markersize=8,
    linestyle='--'
)
ax.plot(
    years,
    non_fiction_share,
    "s-",
    label=non_fiction_label,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",  # orange
    linewidth=2.0,
    markersize=8,
    linestyle='-.'
)
ax.plot(
    years,
    scifi_share,
    "^-",
    label=scifi_label,
    clip_on=False,
    zorder=10,
    color="#9467bd",  # purple
    linewidth=2.0,
    markersize=8,
    linestyle=':'
)

plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_labels, fontsize=yticks_fontsize)

# Set x-axis to only display specific ticks and extend x-axis to leave space at right
plt.xticks(years, fontsize=xticks_fontsize)
plt.xlim(xlim_values)
plt.tick_params(axis="both", which="both", color="gray")

# Add legend, labels, title and grid
ax.legend(
    loc=legend_location,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
)
ax.set_xlabel(xlabel_value, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel_value, fontsize=ylabel_fontsize)
ax.grid(True)
fig.suptitle(supertitle_value, fontsize=16)
ax.set_title(title_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_118.pdf", bbox_inches="tight")
