

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Data for plotting
months = np.array(["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"])
sales = np.array([120, 150, 130, 170, 160, 180, 190, 175, 165, 180, 200, 210])

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0, 11]  # 0 to 11 for 12 months index
xticks_values = np.arange(0, 12, 1)

ylabel_value = "Sales (in thousands)"
ylim_values = [100, 250]
yticks_values = np.arange(100, 251, 25)
yticklabels = [f"${i}k" for i in range(100, 251, 25)]
title = "Monthly Sales Data Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 5))  # Use subplots to get access to the axis object
ax.plot(months, sales, marker="s", linestyle="--", color="#ff7f0e")

# Set y-axis to only display specific ticks
ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)
ax.set_ylim(ylim_values)  # Set limits to include a small margin

# Remove minor ticks
ax.tick_params(axis="y", which="minor", left=False)

# Setting x-axis ticks
ax.set_xticks(xticks_values)  # Index for months
ax.set_xlim(xlim_values)  # Set limits to include a small margin

# Adjusting tick label size
plt.xticks(fontsize=10, fontweight="100")
plt.yticks(fontsize=10, fontweight="100")

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Show grid with lighter color and only major lines
ax.grid(True, which="major", color="lightgrey", linestyle="-", linewidth=0.5)

# Change the axis colors
ax.spines["bottom"].set_color("#d2d2d2")
ax.spines["top"].set_color("#d2d2d2")  # Optional: hide or set color
ax.spines["left"].set_color("#d2d2d2")
ax.spines["right"].set_color("#d2d2d2")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_119.pdf", bbox_inches="tight")

