

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for a business domain
time_periods = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
revenue = np.array([150, 300, 450, 600, 850, 900, 950, 1100, 1200, 1300])
expenses = np.array([100, 150, 200, 350, 500, 450, 500, 600, 550, 600])
profit = revenue - expenses
customer_acquisition = np.array([10, 20, 30, 40, 60, 70, 80, 90, 100, 110])

# Axes Limits and Labels
xlabel_value = "Quarters"
ylabel_value = "Business Metrics"

# Labels
label_1 = "Revenue"
label_2 = "Expenses"
label_3 = "Profit"
label_4 = "Customer Acquisition"

# Titles
title_main = "Business Performance Over Time"
title_1 = "Revenue and Expenses"
title_2 = "Profit and Customer Acquisition"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 6))

# Use a vibrant color palette
color_1 = "#4CAF50" # Green for Revenue
color_2 = "#2196F3" # Blue for Expenses
color_3 = "#FFC107" # Amber for Profit
color_4 = "#FF5722" # Deep Orange for Customer Acquisition

# First subplot
plt.subplot(1, 2, 1)
plt.plot(time_periods, revenue, marker="o", color=color_1, label=label_1, linewidth=2, markersize=6)
plt.plot(time_periods, expenses, marker="^", color=color_2, label=label_2, linewidth=2, markersize=6)
plt.fill_between(time_periods, revenue - 50, revenue + 50, color=color_1, alpha=0.2)
plt.fill_between(time_periods, expenses - 20, expenses + 20, color=color_2, alpha=0.2)
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="upper left")

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(time_periods, profit, marker="s", color=color_3, label=label_3, linewidth=2, markersize=6)
plt.plot(time_periods, customer_acquisition, marker="d", color=color_4, label=label_4, linewidth=2, markersize=6)
plt.fill_between(time_periods, profit - 20, profit + 20, color=color_3, alpha=0.2)
plt.fill_between(time_periods, customer_acquisition - 5, customer_acquisition + 5, color=color_4, alpha=0.2)
plt.title(title_2, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="upper left")

# Super Title
plt.suptitle(title_main, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("line_123.pdf", bbox_inches="tight")
