

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for education domain
years = np.array([2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022])
students_country_a = np.array([1.2, 1.3, 1.5, 1.6, 1.8, 1.4, 1.5, 1.7])  # in millions
students_country_b = np.array([0.9, 1.0, 1.2, 1.1, 1.3, 1.1, 1.2, 1.4])  # in millions

# Labels and titles
xlabel_value = "Years"
ylabel_value = "Student Enrollments (in millions)"
label_1 = "Country A"
label_2 = "Country B"
title_1 = "Higher Education Enrollments in Country A"
title_2 = "Higher Education Enrollments in Country B"
suptitle_value = "Higher Education Enrollments Over Recent Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 5))

# First subplot
plt.subplot(1, 2, 1)
plt.plot(
    years,
    students_country_a,
    marker="v",
    color="#2ca02c",  # green
    label=label_1,
    markerfacecolor="#2ca02c",
    linewidth=2,
    linestyle="--",
    markersize=6,
)
plt.fill_between(years, students_country_a - 0.1, students_country_a + 0.1, color="#2ca02c", alpha=0.2)
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(
    years,
    students_country_b,
    marker="s",
    color="#ff7f0e",  # orange
    label=label_2,
    markerfacecolor="#ff7f0e",
    linewidth=2,
    linestyle="-.",
    markersize=6,
)
plt.fill_between(years, students_country_b - 0.1, students_country_b + 0.1, color="#ff7f0e", alpha=0.2)
plt.title(title_2, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="upper left", frameon=True)

# Add a super title for the whole figure
plt.suptitle(suptitle_value, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust the layout to make room for suptitle
plt.savefig("line_124.pdf", bbox_inches="tight")

