

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)  # For reproducibility

# Define subplot titles (sectors)
titles = [
    "Healthcare",
    "Finance",
    "Education",
    "Manufacturing"
]

# Generate sample data (adoption rates across ratios)
ratios = np.linspace(0.1, 1.0, 5)
adoption_cloud = np.random.uniform(0.20, 0.90, len(ratios))
adoption_ai = np.random.uniform(0.30, 0.85, len(ratios))
adoption_blockchain = np.random.uniform(0.10, 0.70, len(ratios))

# Error margins
error_cloud = np.random.uniform(0.05, 0.10, len(ratios))
error_ai = np.random.uniform(0.04, 0.08, len(ratios))
error_blockchain = np.random.uniform(0.03, 0.07, len(ratios))

# Axes Limits and Labels
xlabel_value = "Sample Size Ratio"
ylabel_value = "Adoption Rate (%)"

# Labels
label_cloud = "Cloud Computing"
label_ai = "AI"
label_blockchain = "Blockchain"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(16, 8))

# Define color palette
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

for i in range(4):
    plt.subplot(2, 2, i + 1)
    plt.plot(ratios, adoption_cloud, "-o", label=label_cloud, color=colors[0], linewidth=2)
    plt.fill_between(ratios, adoption_cloud - error_cloud, adoption_cloud + error_cloud, color=colors[0], alpha=0.2)
    
    plt.plot(ratios, adoption_ai, "-s", label=label_ai, color=colors[1], linewidth=2)
    plt.fill_between(ratios, adoption_ai - error_ai, adoption_ai + error_ai, color=colors[1], alpha=0.2)
    
    plt.plot(ratios, adoption_blockchain, "-^", label=label_blockchain, color=colors[2], linewidth=2)
    plt.fill_between(ratios, adoption_blockchain - error_blockchain, adoption_blockchain + error_blockchain, color=colors[2], alpha=0.2)
    
    plt.title(titles[i], fontsize=14)
    plt.xlabel(xlabel_value, fontsize=12)
    plt.ylabel(ylabel_value, fontsize=12)
    plt.legend(loc="lower right", fontsize=10)
    plt.grid(True)

# Adjust layout for better spacing
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_130.pdf", bbox_inches="tight")

