

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
wheat_yield = [3.2, 4.5, 5.1, 5.8, 6.3, 7.0, 6.8, 6.2, 5.7, 5.0, 4.3, 3.5]
corn_yield = [2.5, 3.2, 4.0, 4.8, 5.6, 6.1, 6.3, 5.7, 5.1, 4.5, 3.7, 3.0]

# Variables for plot configuration
wheat_label = "Wheat Yield (tons)"
corn_label = "Corn Yield (tons)"
xlim_values = (0, len(months) - 1)
ylim_values = (2, 8)
xlabel_text = "Months"
ylabel_text = "Crop Yield (tons)"
xticks_values = np.arange(len(months))
yticks_values = np.arange(2, 9, 1)
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14
title_text = "Monthly Crop Yield in Tons"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(10, 7))  # Adjusting figure size
plt.plot(
    months,
    wheat_yield,
    marker="o",
    linestyle="-",
    linewidth=2.5,
    clip_on=False,
    zorder=10,
    color="#4b8bbe",
    markersize=8,
    label=wheat_label,
    mec="black",
    mfc="#4b8bbe",
    mew=1,
)  # Adjusted color and marker size
plt.plot(
    months,
    corn_yield,
    marker="s",
    linestyle="-.",
    linewidth=2.5,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",
    markersize=8,
    label=corn_label,
    mec="black",
    mfc="#ff7f0e",
    mew=1,
)  # Adjusted color, line style, and marker size

# Adding titles and labels with increased font size
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)
plt.ylim(*ylim_values)
plt.xlim(*xlim_values)
plt.xlabel(xlabel_text, fontsize=xtickslabel_fontsize)
plt.ylabel(ylabel_text, fontsize=ytickslabel_fontsize)
plt.title(title_text, fontsize=18)

# Adding legend
plt.legend(
    markerscale=1,
    fontsize=14,
    loc="best",
    frameon=False,
)

# Changing the background color to #f5f5f5
plt.gca().set_facecolor("#f5f5f5")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")  # Optional: hide or set color
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")  # Optional: hide or set color

plt.tick_params(axis="both", which="both", length=0)
# Adding grid
plt.grid(True, color="white")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_131.pdf", bbox_inches="tight")

