

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
np.random.seed(0)
years = ["2012", "2013", "2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021"]
country_a_sales = [5, 7, 10, 15, 18, 20, 25, 30, 35, 40]  # in millions
country_b_sales = [3, 5, 6, 10, 12, 15, 18, 22, 25, 30]   # in millions

# Variables for plot configuration
country_a_label = "Country A"
country_b_label = "Country B"
xlim_values = (0, len(years) - 1)
ylim_values = (0, 45)
xlabel_text = "Year"
ylabel_text = "Smartphones Sold (Millions)"
xticks_values = np.arange(len(years))
yticks_values = np.arange(0, 46, 5)
xtickslabel_fontsize = 16
ytickslabel_fontsize = 16
title_text = "Smartphone Sales Over Years in Two Countries"
axhline_value = None  # No axhline in this chart
axvline_value = None  # No axvline in this chart

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting the lines
plt.figure(figsize=(9, 6))  # Adjusting figure size
plt.plot(
    years,
    country_a_sales,
    marker="o",
    linestyle="--",
    linewidth=3,
    clip_on=False,
    zorder=10,
    color="#ff6347",  # Tomato color
    markersize=10,
    label=country_a_label,
    mec="#ff4500",  # OrangeRed for marker edge color
    mfc="white",
    mew=2,
)
plt.plot(
    years,
    country_b_sales,
    marker="s",
    linestyle="-.",
    linewidth=3,
    clip_on=False,
    zorder=10,
    color="#1e90ff",  # DodgerBlue color
    markersize=10,
    label=country_b_label,
    mec="#4682b4",  # SteelBlue for marker edge color
    mfc="white",
    mew=2,
)

# Adding titles and labels with increased font size
plt.title(title_text, fontsize=20)
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xticks(xticks_values, labels=years, fontsize=xtickslabel_fontsize)
plt.ylim(*ylim_values)
plt.xlim(*xlim_values)
plt.xlabel(xlabel_text, fontsize=xtickslabel_fontsize)
plt.ylabel(ylabel_text, fontsize=ytickslabel_fontsize)

# Adding legend with square markers
plt.legend(
    markerscale=1,
    fontsize=16,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.25),
    ncol=2,
    frameon=False,
)

# Changing the background color to #f5f5f5
plt.gca().set_facecolor("#f5f5f5")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")  # Optional: hide or set color
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")  # Optional: hide or set color

plt.tick_params(axis="both", which="both", length=0)
# Adding grid
plt.grid(True, color="white")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_132.pdf", bbox_inches="tight")

