

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)
x = [5, 10, 15, 20, 25, 30, 35, 40]
y = [1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5]
categories = [
    "Low",
    "Moderate",
    "Average",
    "Good",
    "Very Good",
    "Excellent",
    "Outstanding",
]

# Axes Limits and Labels
xlabel_value = "Number of Posts Per Week"
xlim_values = [0, 45]
xticks_values = np.arange(5, 41, 5)

ylabel_value = "Average Engagement Rate (%)"
ylim_values = [0, 5]
yticks_values = np.arange(0, 5, 1)

# Labels
label_data = "Post Frequency vs. Engagement Rate"
comparison_1 = "Minimum Engagement: 0%"
comparison_2 = "Average Engagement: 2%"
comparison_3 = "Good Engagement: 3%"
comparison_4 = "High Engagement: 4%"

title = "Impact of Post Frequency on Engagement Rate"
subtitle = "An analysis of how posting frequency influences engagement on social media"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
color_line = "#1f77b4"
color_comparison_1 = "red"
color_comparison_2 = "orange"
color_comparison_3 = "green"
color_comparison_4 = "blue"
marker_style = "o"
line_style = "-"
line_width = 2
marker_size = 8

# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))

# Plot the line
ax.plot(x, y, marker=marker_style, color=color_line, label=label_data, linestyle=line_style, linewidth=line_width, markersize=marker_size)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Annotate the points with categories
for i, txt in enumerate(categories):
    ax.annotate(txt, (x[i], y[i]), textcoords="offset points", xytext=(0, 10), ha="center")

# Horizontal lines for comparison
ax.axhline(y=0.0, color=color_comparison_1, linestyle="--", label=comparison_1)
ax.axhline(y=2.0, color=color_comparison_2, linestyle="--", label=comparison_2)
ax.axhline(y=3.0, color=color_comparison_3, linestyle="--", label=comparison_3)
ax.axhline(y=4.0, color=color_comparison_4, linestyle="--", label=comparison_4)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
fig.suptitle(subtitle, fontsize=10, fontweight='light', y=0.95)

# Set the legend
ax.legend(loc="lower right", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_134.pdf", bbox_inches="tight")
