
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
np.random.seed(0)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul"]
avg_temperatures = [30, 32, 35, 40, 45, 50, 55]
annotations = [
    "Cold Start",
    "Warming Up",
    "Steady Rise",
    "Warmer",
    "Warmest",
    "Cooling Down",
    "Peak Summer",
]

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0, 6]
xticks_values = np.arange(0, 7, 1)
xlabel_ticks = months

ylabel_value = "Average Temperature (°F)"
ylim_values = [25, 60]
yticks_values = np.arange(25, 61, 5)

# Labels
label_1 = "Average Temperature"
label_2 = "Long-term Average: 40°F"
label_3 = "Previous Year Peak: 50°F"
label_4 = "Previous Year Low: 30°F"
label_5 = "Target Peak: 55°F"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 4))

# Plot the line
ax.plot(avg_temperatures, marker="o", color="#1f77b4", label=label_1)

# Set x,y-axis with specific ticks and labels
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, labels=xlabel_ticks, fontsize=10)
plt.xlim(xlim_values)  # Adjust x-axis limit

# Annotate the points with bit values
for i, txt in enumerate(annotations):
    ax.annotate(
        txt, (i, avg_temperatures[i]), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# Horizontal lines for comparison
ax.axhline(y=40, color="magenta", linestyle="--", label=label_2)
ax.axhline(y=50, color="orange", linestyle="--", label=label_3)
ax.axhline(y=30, color="green", linestyle="--", label=label_4)
ax.axhline(y=55, color="red", linestyle="--", label=label_5)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylim(ylim_values)  # Adjust y-axis limit
ax.set_xlim(xlim_values)  # Adjust x-axis limit
ax.set_ylabel(ylabel_value, fontsize=12)

# Set the legend
ax.legend(loc="upper left", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_135.pdf", bbox_inches="tight")
