
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing numpy
import numpy as np

# Data for plotting - Monthly Public Transport Ridership
np.random.seed(1)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct"]
ridership_numbers = [50, 48, 47, 45, 46, 44, 42, 43, 41, 40]  # in '00,000s
ridership_change = [
    "+2.0%",
    "-4.0%",
    "-2.0%",
    "-4.3%",
    "+2.2%",
    "-4.3%",
    "-4.5%",
    "+2.4%",
    "-4.7%",
    "-2.4%",
]

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [-1, 10]  # Extra space for better visualization
xticks_values = np.arange(10)
xticks_labels = months

ylabel_value = "Ridership ('00,000s)"
ylim_values = [35, 55]
yticks_values = np.arange(35, 56, 5)

# Labels
label_1 = "Monthly Ridership"
label_2 = "Starting Ridership: 50 ('00,000s)"
label_3 = "Ending Ridership: 40 ('00,000s)"
title = "Monthly Public Transport Ridership Over 10 Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the line
ax.plot(ridership_numbers, marker="o", linestyle="-.", color="blue", label=label_1)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, xticks_labels, fontsize=10)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Annotate the points with ridership change values
for i, txt in enumerate(ridership_change):
    ax.annotate(
        txt, (i, ridership_numbers[i]), textcoords="offset points", xytext=(0, 8), ha="center"
    )

# Horizontal lines for comparison
ax.axhline(y=50, color="green", linestyle="--", label=label_2)
ax.axhline(y=40, color="red", linestyle="--", label=label_3)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the legend
ax.legend(loc="upper right", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_136.pdf", bbox_inches="tight")
