

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New data for religion trends (percentage of population identifying as religious)
x = [1980, 1990, 2000, 2010, 2020, 2030, 2040, 2050, 2060]
y = [
    70,
    65,
    60,
    55,
    50,
    45,
    40,
    35,
    30,
]  # Simulated data: percentage of population identifying as religious
labels = [
    "70%",
    "65%",
    "60%",
    "55%",
    "50%",
    "45%",
    "40%",
    "35%",
    "30%",
]  # Labels for each point

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1975, 2065]
xticks_values = [1980, 1990, 2000, 2010, 2020, 2030, 2040, 2050, 2060]
xticklabels = [str(year) for year in xticks_values]

ylabel_value = "Percentage of Population Identifying as Religious (%)"
ylim_values = [20, 80]
yticks_values = np.arange(20, 81, 10)

# Chart titles and annotation
title = "Decline in Religious Affiliation Over Time"
supertitle = "Religious Trends Data"
annotation_text = "Annual average percentage of population identifying as religious"

# Legend
legend_labels = ["Religious Affiliation Percentage"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(8, 4)
)  # Adjust the size to fit new data dimensions
ax.plot(
    x,
    y,
    marker="D",
    color="#ff4500",
    linestyle="--",
    linewidth=2,
    markersize=7,
    mfc="#1e90ff",
    mec="black",
    label=legend_labels[0]
)

# Annotate each point with its label
for i, label in enumerate(labels):
    ax.annotate(
        label,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=8,
    )

# Set x-axis labels and limits
ax.set_xticks(xticks_values)
ax.set_xticklabels(
    xticklabels,
)
ax.set_xlim(xlim_values)

# Set y-axis ticks and limits
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)

# Set labels, title, and supertitle
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.suptitle(supertitle, fontsize=12)

# Change the plot background color
ax.set_facecolor("#f0f0f0")

# Show grid
plt.grid(True, which="both", linestyle="-.", linewidth=0.75, color="gray")

# Change the axis colors
ax.spines["bottom"].set_color("#cccccc")
ax.spines["top"].set_color("#cccccc")
ax.spines["left"].set_color("#cccccc")
ax.spines["right"].set_color("#cccccc")

# Add legend
ax.legend(loc="upper left", fontsize=9)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_137.pdf", bbox_inches="tight")
