

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for Unemployment Rate
months = np.arange(1, 13, 1)
average_unemployment_rate = np.array([5.1, 5.0, 5.2, 5.3, 5.4, 5.6, 5.5, 5.4, 5.3, 5.2, 5.1, 5.0])
std_dev_unemployment_rate = np.array([0.3, 0.2, 0.4, 0.3, 0.5, 0.4, 0.3, 0.4, 0.3, 0.2, 0.3, 0.2])

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value = "Unemployment Rate (%)"
ylim_values = [4.5, 6.0]
yticks_values = np.arange(4.5, 6.1, 0.5)

# Labels
label_Average = "Average Unemployment Rate"
label_Standard_Deviation = "Standard Deviation"

# Title
title_value = "Monthly Unemployment Rate in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the average line
plt.figure(figsize=(8, 5))
plt.plot(months, average_unemployment_rate, label=label_Average, marker="o", color="#2ca02c", linestyle='-', linewidth=2)

# Plotting the standard deviation as a shaded area
plt.fill_between(
    months,
    average_unemployment_rate - std_dev_unemployment_rate,
    average_unemployment_rate + std_dev_unemployment_rate,
    color="#2ca02c",
    alpha=0.3,
    label=label_Standard_Deviation,
)

# Adjusting y-axis range
plt.ylim(ylim_values)

# Adding yticks
plt.yticks(yticks_values)

# Adding labels and title with defined font size
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title_value, fontsize=14, fontweight='bold')

# Adding legend with no border
plt.legend(frameon=True, fontsize=11)

# Adding grid
plt.grid(True, color="#e4e4e4")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("line_140.pdf", bbox_inches="tight")

