

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # Ensures reproducibility

# Sample Data: Annual average stock prices and their standard deviations over a decade
years = np.arange(2010, 2020, 1)
average_stock_prices = np.array([50, 52, 54, 56, 59, 63, 67, 70, 74, 78])
std_dev = np.array([2, 2.5, 3, 3.5, 2, 1.5, 1.8, 2.2, 2.5, 3])

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Average Stock Prices (USD)"
ylim_values = [45, 85]
yticks_values = np.arange(45, 85, 5)

# Labels
label_Average = "Average Stock Prices"
label_Standard_Deviation = "Standard Deviation"
suptitle="Annual Average Stock Prices (2010-2019)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the average line
plt.figure(figsize=(8, 5))
color_main = "#FF5733"
color_shade = "#FF5733"

plt.plot(years, average_stock_prices, label=label_Average, marker="^", linestyle="--", color=color_main)

# Plotting the standard deviation as a shaded area
plt.fill_between(
    years,
    average_stock_prices - std_dev,
    average_stock_prices + std_dev,
    color=color_shade,
    alpha=0.2,
    label=label_Standard_Deviation,
)

# Adjusting y-axis range to match the reference picture
plt.ylim(ylim_values)

# Adding yticks
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Adding labels and title with smaller font size
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.suptitle(suptitle, fontsize=14)

# Adding legend with no border
plt.legend(frameon=True, fontsize=10)

# Adding grid
plt.grid(True, color="#e0e0e0", linestyle='--', linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_142.pdf", bbox_inches="tight")

