
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Days of the Week
days = np.array([1, 2, 3, 4, 5, 6, 7])
day_labels = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']

# Attendance Numbers for Three Religious Centers
attendance_mosque = np.array([50, 60, 55, 65, 75, 80, 90])
attendance_church = np.array([40, 50, 45, 55, 60, 70, 85])
attendance_synagogue = np.array([30, 35, 40, 45, 50, 55, 60])

# Error
error = np.array([5, 5, 5, 5, 5, 5, 5])

# Axes Limits and Labels
ylabel_value_1 = "Attendance Numbers"
ylabel_value_2 = "Attendance Numbers"
ylim_values_1 = [0, 100]
yticks_values_1 = [0, 20, 40, 60, 80, 100]
ylim_values_2 = [0, 100]
yticks_values_2 = [0, 20, 40, 60, 80, 100]

# Labels
label_Mosque = "Mosque"
label_Church = "Church"
label_Synagogue = "Synagogue"

# Texts
text_1 = "Days of the Week"
text_2 = "Average Attendance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(8, 6))

# First subplot
ax1.errorbar(
    days,
    attendance_mosque,
    yerr=error,
    label=label_Mosque,
    color="#2ca02c",
    marker="o",
    linestyle='--',
)
ax1.errorbar(
    days,
    attendance_church,
    yerr=error,
    label=label_Church,
    color="#1f77b4",
    marker="s",
    linestyle='-',
)
ax1.errorbar(
    days,
    attendance_synagogue,
    yerr=error,
    label=label_Synagogue,
    color="#8c564b",
    marker="^",
    linestyle=':',
)
ax1.set_ylabel(ylabel_value_1)
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_values_1)
ax1.set_yticks(yticks_values_1)

# Second subplot
ax2.errorbar(
    days,
    attendance_mosque,
    yerr=error,
    label=label_Mosque,
    color="#2ca02c",
    marker="o",
    linestyle='--',
)
ax2.errorbar(
    days,
    attendance_church,
    yerr=error,
    label=label_Church,
    color="#1f77b4",
    marker="s",
    linestyle='-',
)
ax2.errorbar(
    days,
    attendance_synagogue,
    yerr=error,
    label=label_Synagogue,
    color="#8c564b",
    marker="^",
    linestyle=':',
)
ax2.set_ylabel(ylabel_value_2)
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_values_2)
ax2.set_yticks(yticks_values_2)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Add horizontal line at y=60 for reference
for ax in [ax1, ax2]:
    ax.axhline(y=60, color='gray', linestyle='--', linewidth=1, alpha=0.7)
    # Add annotation for the horizontal line
    ax.annotate('Threshold Level', xy=(0.02, 60), xytext=(0.02, 62),
                arrowprops=dict(facecolor='black', shrink=0.05))

f.text(0.55, 0.05, text_1, ha="center", va="center")
f.text(
    0.05,
    0.5,
    text_2,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_143.pdf", bbox_inches="tight")
