
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# Years
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])

# Crop Yields in Tonnes per Hectare
baseline_yield = np.array([2.5, 2.7, 2.9, 3.1, 3.0, 3.3])
irrigation_yield = np.array([3.0, 3.2, 3.5, 3.7, 3.6, 4.0])
fertilizer_yield = np.array([2.8, 3.0, 3.4, 3.5, 3.5, 3.8])

# Error in Yields
error_yield = np.array([0.2, 0.2, 0.3, 0.3, 0.2, 0.3])

# Axes Limits and Labels
ylabel_value_1 = "Yield (Tonnes Per Hectare)"
ylabel_value_2 = "Water Usage (Liters Per Hectare)"
ylim_values_1 = [2.0, 4.5]
yticks_values_1 = [2.0, 2.5, 3.0, 3.5, 4.0, 4.5]
ylim_values_2 = [1500, 4000]
yticks_values_2 = [1500, 2000, 2500, 3000, 3500, 4000]

# Water Usage in Liters per Hectare
baseline_water = np.array([2000, 2100, 2200, 2300, 2400, 2500])
irrigation_water = np.array([3000, 3100, 3200, 3300, 3400, 3500])
fertilizer_water = np.array([2500, 2600, 2700, 2800, 2900, 3000])

# Error in Water Usage
error_water = np.array([100, 100, 120, 120, 100, 120])

# Labels
label_Baseline = "Baseline"
label_Irrigation = "Irrigation"
label_Fertilizer = "Fertilizer"

# Texts
text_1 = "Years"
text_2 = "Values"
title = ["Crop Yield Analysis", "Water Usage Analysis"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(10, 8))

# First subplot for Crop Yield
ax1.errorbar(
    years,
    baseline_yield,
    yerr=error_yield,
    label=label_Baseline,
    color="#ff9999",
    linestyle="--",
    linewidth=2,
    marker="o",
    markersize=8,
)
ax1.errorbar(
    years,
    irrigation_yield,
    yerr=error_yield,
    label=label_Irrigation,
    color="#66b3ff",
    linestyle="-.",
    linewidth=2,
    marker="s",
    markersize=8,
)
ax1.errorbar(
    years,
    fertilizer_yield,
    yerr=error_yield,
    label=label_Fertilizer,
    color="#99ff99",
    linestyle=":",
    linewidth=2,
    marker="^",
    markersize=8,
)
ax1.set_ylabel(ylabel_value_1)
ax1.set_title(title[0])
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_values_1)
ax1.set_yticks(yticks_values_1)

# Second subplot for Water Usage
ax2.errorbar(
    years,
    baseline_water,
    yerr=error_water,
    label=label_Baseline,
    color="#ff9999",
    linestyle="--",
    linewidth=2,
    marker="o",
    markersize=8,
)
ax2.errorbar(
    years,
    irrigation_water,
    yerr=error_water,
    label=label_Irrigation,
    color="#66b3ff",
    linestyle="-.",
    linewidth=2,
    marker="s",
    markersize=8,
)
ax2.errorbar(
    years,
    fertilizer_water,
    yerr=error_water,
    label=label_Fertilizer,
    color="#99ff99",
    linestyle=":",
    linewidth=2,
    marker="^",
    markersize=8,
)
ax2.set_ylabel(ylabel_value_2)
ax2.set_title(title[1])
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_values_2)
ax2.set_yticks(yticks_values_2)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

# Place the legend and adjust subplot parameters
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

f.text(0.55, 0.05, text_1, ha="center", va="center")
f.text(
    0.05,
    0.5,
    text_2,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_145.pdf", bbox_inches="tight")
