
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [2000, 2005, 2010, 2015]
biology_citations = [5.0, 5.8, 6.2, 6.7]
physics_citations = [4.2, 4.9, 5.3, 5.6]
chemistry_citations = [4.8, 5.5, 6.0, 6.5]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1998, 2017]
xticks_values = [2000, 2005, 2010, 2015]
xticklabels = ["2000", "2005", "2010", "2015"]

ylabel_value = "Average Citations per Paper"

# Labels
label_Biology = "Biology"
label_Physics = "Physics"
label_Chemistry = "Chemistry"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years, biology_citations, "o-", label=label_Biology, color="#ffb6b9", linestyle="--", linewidth=2, markersize=8
)
plt.plot(
    years, physics_citations, "x-", label=label_Physics, color="#8ac6d1", linestyle="-.", linewidth=2, markersize=8
)
plt.plot(
    years, chemistry_citations, "s-", label=label_Chemistry, color="#ff8b94", linestyle="-", linewidth=2, markersize=8
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, xticklabels)
plt.xlim(xlim_values) 

# Adding data labels
for i, txt in enumerate(biology_citations):
    plt.annotate(
        txt,
        (years[i], biology_citations[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )
for i, txt in enumerate(physics_citations):
    plt.annotate(
        txt,
        (years[i], physics_citations[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )
for i, txt in enumerate(chemistry_citations):
    plt.annotate(
        txt,
        (years[i], chemistry_citations[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )

# Setting the axis labels
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#cccccc")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#cccccc")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="both", length=0)  # Hide tick marks

# Adding the legend
plt.legend(loc="upper left")

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=1, color="#808080")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_151.pdf", bbox_inches="tight")
