
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data
x = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
company_a_y = [150, 152, 148, 157, 160, 162, 165, 163, 168, 170]
company_b_y = [140, 142, 145, 147, 150, 153, 155, 158, 160, 162]
company_c_y = [130, 133, 136, 139, 142, 145, 147, 149, 152, 155]

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0, 11]
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Stock Price (USD)"
ylim_values = [125, 175]
yticks_values = np.arange(130, 175, 5)

# Labels
label_1 = "Company A"
label_2 = "Company B"
label_3 = "Company C"

title = "Monthly Stock Prices for Three Companies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(6, 4))

# Line charts
ax.plot(x, company_a_y, marker="o", color="#1f77b4", label=label_1, linestyle='-', linewidth=2)
ax.plot(x, company_b_y, marker="s", color="#ff7f0e", label=label_2, linestyle='--', linewidth=2)
ax.plot(x, company_c_y, marker="^", color="#2ca02c", label=label_3, linestyle='-.', linewidth=2)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)
plt.ylim([125, 175])

# Legend
ax.legend(loc="lower right")

# Labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Title
plt.title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_152.pdf", bbox_inches="tight")
