

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
hours = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
route_a_speed = [60, 58, 55, 50, 45, 40, 35, 30, 25, 20]    # Average Speed in mph
route_b_speed = [65, 63, 60, 55, 50, 45, 40, 35, 30, 25]
standard_speed = 50

# Axes Limits and Labels
xlabel_value = "Time (hours)"
ylabel_value = "Average Speed (mph)"
xlim_values = [0, 11]
ylim_values = [0, 70]
xticks_values = np.arange(1, 11, 1)
yticks_values = np.arange(0, 71, 10)

# Labels
label_1 = "Route A"
label_2 = "Route B"
label_3 = "Standard Speed Limit"

title="Traffic Speed Comparison of Two Routes"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 5))

# Line charts
ax.plot(hours, route_a_speed, marker="o", color="#2ca02c", label=label_1, linestyle='-', linewidth=2)
ax.plot(hours, route_b_speed, marker="^", color="#ff7f0e", label=label_2, linestyle='--', linewidth=2)

# Set x,y-axis to display specific ticks
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Horizontal dashed line for industry standard
ax.axhline(y=standard_speed, color="purple", linestyle=":", label=label_3, linewidth=2)

# Title and Legend
ax.set_title(title, fontsize=14)
ax.legend(loc="upper right")

# Labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_153.pdf", bbox_inches="tight")

