
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
months = range(1, 13)
average_temperature = [2, 4, 8, 12, 17, 20, 22, 20, 16, 10, 5, 2]  # Monthly average temperatures (°C)
precipitation = [78, 63, 70, 55, 45, 50, 60, 68, 80, 85, 90, 95]  # Monthly precipitation (mm)

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0, 13]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Values"
ylim_values = [0, 100]

# Title
chart_title = "Monthly Weather Data"

# Labels
label_1 = "Average Temperature (°C)"
label_2 = "Precipitation (mm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(6, 4))
plt.plot(months, average_temperature, marker="o", linestyle="-", label=label_1, color="#1f77b4", linewidth=2, markersize=6)
plt.plot(months, precipitation, marker="s", linestyle="--", label=label_2, color="#ff7f0e", linewidth=2, markersize=6)

# Adding title and legend
plt.title(chart_title)
plt.legend()

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)
plt.ylim(ylim_values)

# Adding grid lines for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

# Reduce the top and right spines
plt.gca().spines['top'].set_visible(False)
plt.gca().spines['right'].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_155.pdf", bbox_inches="tight")
