
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
days = range(1, 16)
car_speeds = np.array([60 + 0.8 * i + np.random.uniform(-1.5, 1.5) for i in days])
truck_speeds = np.array([50 + 0.5 * i + np.random.uniform(-1.0, 1.0) for i in days])

# Axes Limits and Labels
xlabel_value = "Days"
xlim_values = [0, 16]
xticks_values = [0, 5, 10, 15]

ylabel_value = "Average Speed (km/h)"
ylim_values = [45, 80]

# Labels
label_1 = "Car"
label_2 = "Truck"
title_value = "Average Speed of Vehicles Over 15 Days"
legend_labels = [label_1, label_2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(6, 4))
plt.plot(days, car_speeds, "o--", label=label_1, color="#1f77b4", linewidth=2, markersize=6)
plt.plot(days, truck_speeds, "s-", label=label_2, color="#ff7f0e", linewidth=2, markersize=6)

# Adding title and legend
plt.title(title_value)
plt.legend()

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)

# Adding grid for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_156.pdf", bbox_inches="tight")
