

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data assumption: Battery Life performance under different temperatures
temperatures = np.arange(-20, 50, 10)
method_a_life = [5, 8, 12, 10, 7, 3, 2]
method_b_life = [6, 10, 14, 13, 9, 4, 3]
method_c_life = [4, 7, 11, 9, 6, 2, 1]
method_d_life = [5, 9, 13, 11, 8, 3, 2]

# Plausible error values
method_a_error = np.random.uniform(0.5, 1.5, len(temperatures))
method_b_error = np.random.uniform(0.6, 1.6, len(temperatures))
method_c_error = np.random.uniform(0.4, 1.4, len(temperatures))
method_d_error = np.random.uniform(0.5, 1.5, len(temperatures))

# Axes Limits and Labels
xlabel_value = "Temperature (°C)"
ylabel_value = "Battery Life (hours)"
ylim_values = [0, 16]
yticks_values = np.arange(0, 17, 2)

# Labels
label_1 = "Method A"
label_2 = "Method B"
label_3 = "Method C"
label_4 = "Method D"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 7))
plt.errorbar(
    temperatures,
    method_a_life,
    yerr=method_a_error,
    fmt="-o",
    label=label_1,
    color="darkblue",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)
plt.errorbar(
    temperatures,
    method_b_life,
    yerr=method_b_error,
    fmt="-s",
    label=label_2,
    color="darkgreen",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)
plt.errorbar(
    temperatures,
    method_c_life,
    yerr=method_c_error,
    fmt="-^",
    label=label_3,
    color="darkorange",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)
plt.errorbar(
    temperatures,
    method_d_life,
    yerr=method_d_error,
    fmt="-d",
    label=label_4,
    color="darkred",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.xticks(temperatures)
plt.ylim(ylim_values)
plt.yticks(yticks_values)

# Adding legend, lower left corner
plt.legend(loc="upper right", fontsize=12)

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_163.pdf", bbox_inches="tight")

