

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
time_intervals = ["Morning", "Afternoon", "Evening", "Night"]
traffic_volume_highway_1 = [1200, 1400, 1600, 1000]
traffic_volume_highway_2 = [1100, 1300, 1500, 900]

# Axes Limits and Labels
xlabel_value = "Time of Day"
xlim_values = [-1, 4]
xticks_values = np.arange(4)

ylabel_value = "Traffic Volume (Vehicles per Hour)"
ylim_values = [800, 1700]
yticks_values = np.arange(800, 1701, 100)

# Labels
label_highway_1 = "Highway 1"
label_highway_2 = "Highway 2"

# Titles
title_1 = "Traffic Volume over Different Times of Day"
title_2 = "Highway Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax = plt.subplots(figsize=(10, 6))
ax.plot(
    time_intervals,
    traffic_volume_highway_1,
    marker="s",
    color="#1f77b4",
    linewidth=2,
    markersize=8,
    markerfacecolor="#1f77b4",
    label=label_highway_1,
)

ax.plot(
    time_intervals,
    traffic_volume_highway_2,
    marker="^",
    linestyle="--",
    color="#2ca02c",
    linewidth=2,
    markersize=8,
    markerfacecolor="#2ca02c",
    label=label_highway_2,
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values, time_intervals, fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit

# Set the title and labels
ax.set_title(title_1, fontsize=20)
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Add a legend with a title
ax.legend(
    title=title_2,
    loc="lower left",
    fontsize=12,
    title_fontsize=12,
    edgecolor="#e0e0e0",
)

# Change the plot background color
ax.set_facecolor("#f0f0f0")

# Show grid with lighter color
ax.grid(True, color="#cccccc", linewidth=1.2)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#b0b0b0")
ax.spines["top"].set_color("#b0b0b0")  # Optional: hide or set color
ax.spines["left"].set_color("#b0b0b0")
ax.spines["right"].set_color("#b0b0b0")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_166.pdf", bbox_inches="tight")

