
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Generate average monthly revenue data for 4 movie genres across 12 months
months = np.arange(1, 13)
action = [120, 150, 170, 130, 160, 180, 190, 200, 175, 160, 140, 130]
comedy = [100, 120, 110, 90, 100, 130, 140, 150, 135, 120, 110, 105]
drama = [80, 100, 90, 70, 80, 100, 110, 115, 105, 95, 85, 80]
horror = [60, 70, 65, 50, 60, 80, 90, 100, 85, 70, 60, 55]

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0.5, 12.5]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Average Monthly Revenue (in $1,000s)"
ylim_values = [0, 220]
yticks_values = np.arange(0, 221, 20)

# Labels
label_1 = "Action"
label_2 = "Comedy"
label_3 = "Drama"
label_4 = "Horror"
title = "Average Monthly Revenue for Different Movie Genres"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(10, 6))  # Adjust the figure size
plt.plot(months, action, marker="o", linestyle="-", color="#FF5733", label=label_1, linewidth=2)
plt.plot(months, comedy, marker="s", linestyle="--", color="#33FF57", label=label_2, linewidth=2)
plt.plot(months, drama, marker="^", linestyle="-.", color="#3357FF", label=label_3, linewidth=2)
plt.plot(months, horror, marker="v", linestyle=":", color="#FF33A1", label=label_4, linewidth=2)

# Set x,y-axis properties
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Add grid for better readability
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend(loc="upper left", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_167.pdf", bbox_inches="tight")
