

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for art movement trends over years
years = [1980, 1990, 2000, 2010, 2020]
impressionism = [0.50, 0.55, 0.50, 0.45, 0.40]  # Impressionism proportion
abstract = [0.30, 0.35, 0.40, 0.45, 0.50]  # Abstract proportion
surrealism = [0.20, 0.25, 0.30, 0.35, 0.40]  # Surrealism proportion
modern = [0.10, 0.15, 0.25, 0.30, 0.35]  # Modern proportion

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1975, 2025]
xticks_values = np.arange(1980, 2021, 10)

ylabel_value = "Proportion of Popularity"
ylim_values = [0.00, 0.60]
yticks_values = np.arange(0.0, 0.61, 0.10)

# Labels
label_1 = "Impressionism"
label_2 = "Abstract"
label_3 = "Surrealism"
label_4 = "Modern"
title="Trends of Art Movements Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 5))  # Adjusted to match the original image's dimensions
plt.plot(years, impressionism, marker="o", linestyle="-", color="#1f77b4", label=label_1)
plt.plot(years, abstract, marker="s", linestyle="--", color="#2ca02c", label=label_2)
plt.plot(years, surrealism, marker="^", linestyle=":", color="#ff7f0e", label=label_3)
plt.plot(years, modern, marker="d", linestyle="-.", color="#d62728", label=label_4)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)  
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  

# Add vertical dotted line
plt.axvline(x=2000, color="grey", linestyle=":", linewidth=1.2)

# Add legend
plt.legend(loc="lower right", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# Add grid for better readability
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_168.pdf", bbox_inches="tight")
