

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New sample data for entertainment domain
years = [2010, 2012, 2014, 2016, 2018, 2020]
ticket_sales = [70, 68, 65, 60, 58, 50]          # Ticket sales in %
box_office_earnings = [80, 82, 85, 87, 83, 75]   # Box office earnings in %
streaming_growth = [10, 15, 25, 35, 50, 70]      # Streaming service growth in %
cinema_closures = [5, 7, 10, 12, 15, 18]         # Cinema closures in %

# Axes limits and labels
xlabel_value = "Year"
xlim_values = [2009, 2021]
xticks_values = np.arange(2010, 2021, 2)

ylabel_value = "Percentage"
ylim_values = [0, 100]
yticks_values = np.arange(0, 101, 10)

# Labels
label_ticket_sales = "Ticket Sales"
label_box_office = "Box Office Earnings"
label_streaming = "Streaming Growth"
label_cinema_closures = "Cinema Closures"
title="Entertainment Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))

# Style and plotting each line
plt.plot(years, ticket_sales, marker="o", linestyle="--", color="#1f77b4", label=label_ticket_sales)
plt.plot(years, box_office_earnings, marker="s", linestyle="-", color="#ff7f0e", label=label_box_office)
plt.plot(years, streaming_growth, marker="^", linestyle=":", color="#2ca02c", label=label_streaming)
plt.plot(years, cinema_closures, marker="d", linestyle="-.", color="#d62728", label=label_cinema_closures)

# Setting x, y-axis ticks and limits
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Add vertical dotted line to mark significant event year
plt.axvline(x=2016, color="gray", linestyle=":", linewidth=1.2)

# Add legend
plt.legend(loc="upper left", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# Add grid for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_169.pdf", bbox_inches="tight")

