

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for plotting
years = np.array([1990, 1995, 2000, 2005, 2010, 2015, 2020])
publications = np.array([100, 500, 2000, 5000, 10000, 20000, 30000])

# Labels and Plot Types
x_internet = 1995
label_internet = "Internet"
x_machine_learning = 2000
label_machine_learning = "Machine Learning"
x_blockchain = 2010
label_blockchain = "Blockchain"
x_quantum_computing = 2020
label_quantum_computing = "Quantum Computing"
label_empirical_curve = "Publication Growth"

# Axes Limits and Labels
yticks_values = np.arange(0, 35000, 5000)
ylim_values = [0, 32000]
xlabel_value = "Year"
ylabel_value = "Number of Publications"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Add vertical lines
ax.axvline(
    x=x_internet,
    color="#66c2a5",
    linestyle="--",
    label=label_internet,
    linewidth=2,
)
ax.axvline(
    x=x_machine_learning,
    color="#fc8d62",
    linestyle="--",
    label=label_machine_learning,
    linewidth=2,
)
ax.axvline(
    x=x_blockchain,
    color="#8da0cb",
    linestyle="--",
    label=label_blockchain,
    linewidth=2,
)
ax.axvline(
    x=x_quantum_computing, 
    color="#e78ac3", 
    linestyle="--", 
    label=label_quantum_computing, 
    linewidth=2
)

# Plot the empirical relationship line
ax.plot(
    years,
    publications,
    label=label_empirical_curve,
    color="#a6d854",
    marker="s",
    markersize=8,
    mec="black",
    linewidth=3,
)

# Set yticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the plot
ax.set_xscale("linear")
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Remove x-axis minor ticks
ax.tick_params(axis="x", which="minor", bottom=False)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="--", linewidth=0.7, color="gray")

# Add legend
ax.legend(loc="upper left", bbox_to_anchor=(0, 1), fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig("line_174.pdf", bbox_inches="tight")
