

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Sample data
time_periods = np.array([f"{i+1}" for i in range(10)])
industrial_rev_scores = np.array([50, 55, 60, 65, 70, 75, 80, 85, 90, 95])
tech_rev_scores = np.array([40, 45, 50, 60, 70, 80, 85, 90, 95, 100])
industrial_rev_std = np.array([3] * 10)
tech_rev_std = np.array([4] * 10)

# Axes Limits and Labels
xlabel_value = "Time Period"
ylabel_value = "Significance Score"
xlim_values = [-0.5, 9.5]
xticks_values = np.arange(10)

# Titles
titles = ["Industrial Revolution over Time", "Technological Revolution over Time", "Comparison"]

# Labels
labels = ["Industrial Revolution", "Technological Revolution"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(18, 6))
colors = ["#1f77b4", "#ff7f0e"]  # Custom business-like colors
markers = ["o", "^"]  # Circle and triangle markers

for i, ax in enumerate(axs):
    if i < 2:
        scores = industrial_rev_scores if i == 0 else tech_rev_scores
        stds = industrial_rev_std if i == 0 else tech_rev_std
        label = labels[i]
        color = colors[i]

        ax.plot(time_periods, scores, label=label, color=color, marker=markers[i], linewidth=2, linestyle="--")
        ax.fill_between(time_periods, scores - stds, scores + stds, color=color, alpha=0.2)
    else:
        ax.plot(time_periods, industrial_rev_scores, label=labels[0], color=colors[0], marker=markers[0], linewidth=2, linestyle="--")
        ax.fill_between(time_periods, industrial_rev_scores - industrial_rev_std, industrial_rev_scores + industrial_rev_std, color=colors[0], alpha=0.2)
        ax.plot(time_periods, tech_rev_scores, label=labels[1], color=colors[1], marker=markers[1], linewidth=2, linestyle="--")
        ax.fill_between(time_periods, tech_rev_scores - tech_rev_std, tech_rev_scores + tech_rev_std, color=colors[1], alpha=0.2)

    ax.set_xticks(xticks_values)
    ax.set_xticklabels(time_periods)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i], fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.grid(True, linestyle='--', alpha=0.7)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

# Set y-axis properties
for ax in axs:
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.set_ylim([30, 110])
    ax.legend(loc="lower right", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_176.pdf", bbox_inches="tight")
