
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for Air Quality Index (AQI)
time_points = np.arange(1, 11, 1)  # Time units (e.g., hours or days)
station_a_aqi = np.array([50, 55, 60, 58, 62, 65, 70, 68, 72, 75])
station_b_aqi = np.array([40, 42, 44, 47, 49, 52, 55, 57, 59, 61])
station_a_std = np.array([3] * 10)
station_b_std = np.array([4] * 10)

# Axes Limits and Labels
xlabel_value = "Time (hours)"
xlim_values = [0, 11]
xticks_values = np.arange(1, 12, 1)

ylabel_value = "AQI Level"
yticks_values_1 = np.arange(30, 90, 10)
ylim_values_1 = [30, 80]
yticks_values_2 = np.arange(30, 90, 10)
ylim_values_2 = [30, 80]
yticks_values_3 = np.arange(30, 90, 10)
ylim_values_3 = [30, 80]

# Labels
labels = ["Station A", "Station B"]

# Titles
titles = ["AQI - Morning", "AQI - Afternoon", "AQI - Evening"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(15, 5))
colors = ["#1f77b4", "#2ca02c"]  # Blue and Green
markers = ["o", "D"]  # Circle and Diamond markers

for i, ax in enumerate(axs):
    ax.plot(
        time_points, station_a_aqi, label=labels[0], color=colors[0], marker=markers[0]
    )
    ax.fill_between(
        time_points,
        station_a_aqi - station_a_std,
        station_a_aqi + station_a_std,
        color=colors[0],
        alpha=0.2,
    )
    ax.plot(
        time_points, station_b_aqi, label=labels[1], color=colors[1], marker=markers[1]
    )
    ax.fill_between(
        time_points,
        station_b_aqi - station_b_std,
        station_b_aqi + station_b_std,
        color=colors[1],
        alpha=0.2,
    )
    ax.set_xticks(xticks_values)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i])
    ax.set_xlabel(xlabel_value)
    ax.grid(True)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

# Move legend inside the plot area
axs[0].legend(loc="upper left")
axs[1].legend(loc="lower right")
axs[2].legend(loc="lower left")

# Adjust y-axis label to match reference picture
axs[0].set_ylabel(ylabel_value)
axs[1].set_ylabel(ylabel_value)
axs[2].set_ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_178.pdf", bbox_inches="tight")
