
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for basketball player's points per game over a 26-game season
games_played = np.arange(1, 27, 1)
points_mean = np.array(
    [
        25.0, 24.5, 26.0, 27.5, 28.0, 27.0, 26.5, 25.0, 24.0, 23.5,
        24.5, 25.0, 26.0, 27.0, 28.0, 29.0, 28.5, 27.5, 26.0, 25.5,
        26.5, 27.0, 28.0, 29.0, 28.5, 27.5
    ]
)
points_std = np.array(
    [
        2.5, 2.4, 2.3, 2.2, 2.1, 2.1, 2.0, 1.9, 1.8, 1.7,
        1.7, 1.6, 1.6, 1.5, 1.5, 1.4, 1.4, 1.3, 1.3, 1.2,
        1.2, 1.2, 1.1, 1.1, 1.0, 1.0
    ]
)

# Axes Limits and Labels
xlabel_value = "Games Played"
xlim_values = [0, 27]
xticks_values = np.arange(1, 27, 2)

ylabel_value = "Points Per Game (PPG)"
ylim_values = [20.0, 35.0]

# Title and Legend Labels
title_value = "Basketball Player's Points Per Game (PPG) Over a Season"
legend_mean_label = "Mean Points Per Game"
legend_std_label = "Standard Deviation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean points per game with the standard deviation as a shaded area
plt.figure(figsize=(8, 6))
plt.plot(games_played, points_mean, label=legend_mean_label, color="#1f78b4", linestyle='-', linewidth=2, marker='o')
plt.fill_between(
    games_played,
    points_mean - points_std,
    points_mean + points_std,
    color="#a6cee3",
    alpha=0.4,
    label=legend_std_label
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title_value, fontsize=18, pad=20)

# Adding a Legend
plt.legend(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_179.pdf", bbox_inches="tight")
