

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for Environmental Science domain (e.g., Average monthly temperatures)
month = np.arange(1, 13, 1)
average_temp_mean = np.array(
    [
        4.2, 5.8, 9.5, 13.3, 18.2, 21.1, 24.5, 24.1, 20.0, 14.5, 9.0, 4.2
    ]
)
average_temp_std = np.array(
    [
        1.5, 1.5, 1.2, 1.1, 0.8, 0.6, 0.5, 0.6, 0.9, 1.2, 1.4, 1.5
    ]
)

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0.5, 12.5]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Average Temperature (°C)"
ylim_values = [0.0, 40.0]

# Chart Titles and Legend Labels
title = "Average Monthly Temperature Over a Year"
legend_label = "Average Temperature ± Std Dev"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean temperature with the standard deviation as a shaded area
plt.figure(figsize=(8, 6))
plt.plot(month, average_temp_mean, color="#ff6347", linestyle='-', linewidth=2, marker='o', markersize=6, label=legend_label)
plt.fill_between(
    month,
    average_temp_mean - average_temp_std,
    average_temp_mean + average_temp_std,
    color="#ff6347",
    alpha=0.2,
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adding title and legend
plt.title(title, fontsize=18)
plt.legend(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_180.pdf", bbox_inches="tight")
