

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data: Monthly Rainfall in a City (in mm)
months = np.arange(1, 13, 1)
rainfall_mean = np.array([
    80, 60, 75, 100, 150, 200, 220, 210, 160, 110, 90, 70
])
rainfall_std = np.array([
    10, 15, 20, 15, 25, 30, 35, 25, 20, 15, 10, 10
])

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0.5, 12.5]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Rainfall (mm)"
ylim_values = [0, 300]

# Chart title and legend labels
chart_title = "Average Monthly Rainfall"
legend_label_mean = "Mean Rainfall"
legend_label_std = "Standard Deviation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean rainfall with the standard deviation as a shaded area
plt.figure(figsize=(10, 6))
plt.plot(months, rainfall_mean, color="#2ca02c", linestyle='--', linewidth=2, label=legend_label_mean)
plt.fill_between(
    months,
    rainfall_mean - rainfall_std,
    rainfall_mean + rainfall_std,
    color="#98df8a",
    alpha=0.3,
    label=legend_label_std
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes and chart title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(chart_title, fontsize=18)

# Adding legend
plt.legend(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_181.pdf", bbox_inches="tight")

