
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
decades = ["1960s", "1970s", "1980s", "1990s", "2000s", "2010s"]
baseline_growth = [3.5, 3.2, 3.0, 3.1, 2.8, 2.5]
country_a = [4.0, 3.8, 3.7, 4.1, 3.9, 3.6]
country_b = [2.5, 2.8, 3.0, 2.9, 2.7, 2.6]
country_c = [1.5, 2.0, 2.8, 3.0, 3.2, 3.1]
country_d = [3.0, 3.2, 3.4, 3.3, 3.5, 3.4]
country_e = [2.0, 2.5, 2.7, 2.8, 2.9, 3.0]

# Axes Limits and Labels
xlabel_value = "Decades"
ylabel_value = "GDP Growth Rate (%)"
ylim_values = [1.0, 5.0]
yticks_values = np.arange(1.0, 5.5, 0.5)

# Labels
label_baseline = "Baseline Growth"
label_a = "Country A"
label_b = "Country B"
label_c = "Country C"
label_d = "Country D"
label_e = "Country E"

# Plot Title
title_value = "GDP Growth Rate Comparison Over Decades"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 5))
plt.axhline(y=3.0, color="grey", linestyle="--", linewidth=2, label=label_baseline)
plt.plot(decades, country_a, color="#1f77b4", marker="o", linestyle="-", linewidth=2, label=label_a)
plt.plot(decades, country_b, color="#ff7f0e", marker="s", linestyle="-", linewidth=2, label=label_b)
plt.plot(decades, country_c, color="#2ca02c", marker="^", linestyle="-", linewidth=2, label=label_c)
plt.plot(decades, country_d, color="#d62728", marker="v", linestyle="-", linewidth=2, label=label_d)
plt.plot(decades, country_e, color="#9467bd", marker="d", linestyle="-", linewidth=2, label=label_e)

plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)

# Set x-axis labels equidistantly
ax = plt.gca()
ax.set_xticks(np.arange(len(decades)))
ax.set_xticklabels(decades, fontsize=12)

plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

plt.legend(
    loc="lower right", ncol=2, fontsize=12, columnspacing=5
)  # Adjusted legend settings

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_182.pdf", bbox_inches="tight")
