
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = ["Year 1", "Year 2", "Year 3", "Year 4", "Year 5"]
city_A = [15.0, 16.2, 17.1, 18.0, 18.5]
city_B = [20.0, 21.5, 22.3, 23.0, 23.7]
city_C = [10.5, 11.7, 12.0, 12.8, 13.2]
city_D = [5.0, 6.0, 7.2, 8.0, 8.7]
city_E = [25.0, 26.5, 27.1, 28.0, 28.5]

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Average Monthly Temperature (°C)"
ylim_values = [0.0, 30.0]
yticks_values = np.arange(0.0, 31.0, 5.0)

# Labels
label_city_A = "City A"
label_city_B = "City B"
label_city_C = "City C"
label_city_D = "City D"
label_city_E = "City E"

title="Average Monthly Temperature Over Years"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 4))
plt.plot(years, city_A, "o-", color="#1f77b4", linewidth=2, markersize=8, label=label_city_A)
plt.plot(years, city_B, "v-", color="#ff7f0e", linewidth=2, markersize=8, label=label_city_B)
plt.plot(years, city_C, "s-", color="#2ca02c", linewidth=2, markersize=8, label=label_city_C)
plt.plot(years, city_D, "P-", color="#d62728", linewidth=2, markersize=8, label=label_city_D)
plt.plot(years, city_E, "D-", color="#9467bd", linewidth=2, markersize=8, label=label_city_E)

plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# x-axis labels
ax = plt.gca()
ax.set_xticks(np.arange(len(years)))  # Positional indexing for equidistant spacing
ax.set_xticklabels(years, fontsize=14)  # Labeling x-ticks as per versions

plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

plt.legend(loc="lower right", ncol=1, fontsize=12)

# Title and layout adjustments
plt.title(title, fontsize=18)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_183.pdf", bbox_inches="tight")
